/*
** $Header: /home/vikas/src/nocol/include/RCS/netconsole.h,v 1.22 1998/07/31 18:17:14 vikas Exp $
*/

#ifndef __netconsole_h
# define __netconsole_h

/*
 *		INCLUDE FILES
 */
#include "nocol.h"
#include <ctype.h>
#include <signal.h>

#ifdef USE_NCURSES
# include <ncurses.h>
#else
# include <curses.h>
#endif

#include <dirent.h>

/*
 * For 4.2 curses.
 */
#if defined(VMS) || defined(__convex__) || defined(sequent)
# ifndef cbreak
#  define cbreak crmode
# endif
# ifndef nocbreak
#  define nocbreak nocrmode
# endif
#endif

/*
 * If using the ncurses library in Linux, then it should compile
 * WITHOUT the following defines...
 */
#ifdef BROKEN_CURSES
# define _maxy maxy
# define _cury cury
# define _curx curx
# define bool int
# include <asm/termios.h>
#endif

#if defined(__NetBSD__) || defined(BSDI)
# define _maxy maxy
# define _cury cury
# define _curx curx
# define _begy begy
# define _begx begx
# include <termios.h>
#endif	/* __NetBSD__ */


/*
 * Usually defined in ttychars.h.
 */
#ifndef ESC             /* ESCAPE character */
#define ESC 033
#endif

#ifndef RUBOUT
#define RUBOUT        	'\177'
#endif

#ifndef erasechar
#define erasechar()	RUBOUT
#endif

#ifdef CTRL             /* Some implementations do a: c & 037 (assume int) */
#undef CTRL             /* and some do 'c' & 037, so use our version... */
#endif  /* CTRL */
#define CTRL(c)         (c & 037)	/* treat as an integer */

#ifndef beep				/* crude way of doing it.. */
#define beep() (fprintf (stderr, "%c", 007))
#endif    /* beep */

#ifndef max
#define max(a, b)	((a) > (b) ? (a) : (b))
#endif	/* endif max */

#ifndef HELPFILE
#define HELPFILE 	"./netconsole-help"
#endif

/*
 * Define NETLOG if you want to invoke 'netlog' from netconsole when the user
 * hits the 'n' option. This is invoking another program so be careful in who
 * is allowed access to this program.
 */
/* #define NETLOG	/* */

/*
 * 'netconsole' extracts the terminal capabilities from /etc/termcap. Some
 * terminals are very common and are present in every 'termcap', so you
 * can list those terminals here to prevent doing a lookup using 'tgetent'.
 *
 * On the other hand, there are some terminals in /etc/termcap that are
 * set by standard programs by default (like 'network' or 'ethernet', in
 * which case you might want to query the user for the terminal type
 * instead of accepting them as 'dumb' right away. List those terminals
 * here too.
 *
 */

#define GOODTERMINALS	"vt100", "vt200", "xterm", "sun"
#define BADTERMINALS	"ethernet", "network", "dialup"


/*******************  Rest is fairly standard ****************************/

#define PAUSE		15			/* wait secs for poll()	*/


/*
**	Global definitions
*/
#define MAXWORD		15

char *prognm;					/* program name		*/
char *datadir ;					/* Dir of data files	*/
char *msgsdir ;					/* Dir with text msg files */
char *helpfile ;				/* help file 		*/
char *pattern;					/* filter pattern string */
char bolds[MAXWORD];				/* Bold sequence	*/
char bolde[MAXWORD];				/* Bold end sequence	*/
char clscr[MAXWORD];			    	/* Clear screen sequence */
char bellstr[MAXWORD];				/* Bell sequence */

#undef MAXWORD					/* not needed anymore */

int debug;
int emode;				/* expanded display (132 cols) */
int level;				/* display level */
int page;				/* Page number */
int quiet;				/* toggle bell off or on */
int msg_on;				/* toggle for msg_dpy()	*/
int silent;				/* Command line never beep */
int entered_curses ;			/* so done can call endwin */
int isdefined_pattern;			/* filter pattern in effect */
int titlesz, hdrsz, promptsz, 		/* various window sizes	*/
  msgtitlesz, msgsz, eventsz ;
bool  frozen ;				/* indefinite poll wait	*/

extern char *good_terminals[],
  *bad_terminals[] ;				/* defined in main()	*/
extern char *tgetstr() ;			/* 'termcap' routine	*/
int outchar() ;					/* func for tgetstr() */

/*
 * The netconsole screen is made up of several subwindows. This struct is
 * essentially a list of all the windows on the main netconsole screen.
 */
struct allwins
{
    WINDOW    	*wmain;
    WINDOW     	*wtitle;			/* the title window	*/
    WINDOW	*whdr;				/* the column headers	*/
    WINDOW	*wevent;			/* the event window	*/
    WINDOW	*wmsgtitle;			/* message window title	*/
    WINDOW	*wmsg;				/* the small msg win	*/
    WINDOW	*wprompt;			/* the prompt window	*/
} aw;				/* aw allocates storage for the struct	*/

/*  Window sizes:
** Initially 'wevent' size is computed as the remaining lines after all 
** else. After that it can be changed by the user.
** LINES & COLS is set in <curses.h>
*/

#define TITLESZ		2			/* one blank line	*/
#define HDRSZ		2			/* one blank line	*/
#define MSGTITLESZ	2			/* one blank line	*/
#define MSGSZ		3			/* Messages window	*/
#define PROMPTSZ	2			/* one blank line above	*/
#define EVENTSZ		LINES - (TITLESZ+HDRSZ+MSGTITLESZ+MSGSZ+PROMPTSZ)

#define MNCOLS		80		/* depends on extended display	*/

/*+ 
** Display strings and formats
*/

#define PROMPTA "Enter option, 'q' to quit, 'h' for help: "
#define PROMPTB "Enter option, or any other key for next screen: "

/*
 * The header names and the formats are coded here. They depend on the 'event'
 * structure and should be modified with care. Make sure that you match the
 * sizes with the size of the various fields in 'nocol.h'. Leave space for
 * the 'condition' string added at the end.
 */
/*                        1         2         3         4         5         6         7         8         9         0         1         2 */
/*               123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789. */
#define EHDR	"         Site      Address      Date  Time   +- Sender -+  +-- Variable --+ +- Value-+  + Thres -+    Units  Flags  Condition "
/*               +++++++++|++++  +++++++++|+++++ ++/++ ++:++  +++++++++|++  +++++++++|++++++ +++++++++|  +++++++++|  ++++++++  +++   END */
#define EFMT 	"%14.14s  %-15.15s %02d/%02d %02d:%02d  %-12.12s  %16.16s %10lu  %10lu  %8.8s  %03o   "	/* Condition added at end */
#define EFIELDS v.site.name, v.site.addr, v.mon,v.day,v.hour,v.min, v.sender, v.var.name, v.var.value, v.var.threshold, v.var.units, v.nocop

/*               123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789. */
#define SHDR	"         Site      Address      Time   +-Variable-+ +-Value-+  Condition  "
/*               +++++++++|++++  +++++++++|+++++ ++/++  +++++++++|++ ++++++++    END */
#define SFMT	"%14.14s  %-15.15s %02d:%02d  %12.12s %8lu    "  /* 62 chars */
#define SFIELDS	v.site.name, v.site.addr, v.hour, v.min, v.var.name, v.var.value


/*
 * Define types of user responses for get_reply()
 */
#define C_ANY		0x0	/* Any character (printable or non-) */
#define C_ALPHA		0x1	/* A-z */
#define C_DIGIT		0x2	/* 0-9 */
#define C_SPACE		0x4	/* SPACE, TAB */
#define C_PUNCT		0x8	/* All punctuation characters */

/*
 * These are usually defined in sys/file.h.  Needed for flock
 */
#ifndef LOCK_SH
# define   LOCK_SH   1    /* shared lock */
# define   LOCK_EX   2    /* exclusive lock */
# define   LOCK_NB   4    /* don't block when locking */
# define   LOCK_UN   8    /* unlock */
#endif	/* LOCK_SH */

#endif	/* ! __netconsole_h */
