/*	$Header: /home/vikas/src/nocol/include/RCS/nocol.h,v 2.1 1998/07/31 18:17:39 vikas Exp $	*/

/*
 * Copyright (c) 1994 Vikas Aggarwal, vikas@navya.com
 * (see COPYRIGHT file for full information)
 */

/*************************/
/* 	NOCOL.H          /
/***********************/

#ifndef __nocol_h
# define __nocol_h

#include "osdefs.h"
#include "version.h"

/* need these include files for inet routines */
#include <sys/types.h>
#include <stdio.h>
#include <errno.h>			/* doesn't define sys_errlist */
#ifndef NeXT
#  include <unistd.h>			/* for access(), lseek()  */
#endif	/* NeXT */
#include <time.h>			/* AIX wants time.h */
#include <sys/time.h>
#ifdef sun
#  include <sys/socket.h>
#endif
#include <netinet/in.h>
#include <arpa/inet.h>

#include <sys/file.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifdef AIX
# include <sys/select.h>		/* all fd_set definitions here */
#endif

#ifndef HAVESYSERR		/* good old FreeBSD */
extern char *sys_errlist[];
#endif

#ifdef SVR4
void    (*bsdsignal())();	/* in use our own signal routines */
#endif	/* SVR4 */

/*************************
 * Directory definitions *
 *************************/

/*
 * IT IS PREFERABLE TO DEFINE THE FOLLOWING DEFINITIONS IN THE MAKEFILE
 * BY SETTING 'TOPDIR' RATHER THAN INDIVIDUAL DEFINITIONS HERE.
 *
 * All program generate data fles in the DATADIR. The display program
 * opens and displayes all files in the DATADIR.
 *
 * The 'MSGSDIR' is used for the message display. Any file in this directory
 * will be treated as a ascii text file and its contents will be displayed in
 * the 'Message' sub-window in nocol.
 *
 * The configuration and PID files are stored in the ETCDIR.
 *
 */
#ifndef DATADIR				/* data files in this dir */
# define DATADIR	"../../data"
#endif

#ifndef MSGSDIR				/* special text msgs here */
# define MSGSDIR	"../../msgs"
#endif

#ifndef ETCDIR				/* config & pid files */
#  define ETCDIR         "../../etc"
#endif


#define OUTPUTEXT	"-output"		/* extension of data-files */
#define DATAFILE_MODE	0664			/* mode of data files */


/*
 *		CONSTANTS
 */
#ifndef BUFSIZ		      		/* in stdio.h */
# define BUFSIZ 1024
#endif /* BUFSIZ */

#define MAXLINE		128		/* Randomly selected string length */


/**************************
 * The NOCOL data structure.
 **************************/

typedef char BYTE;		/* an 8-bit field */

#define MAXPROGNM	12	/* Name of monitoring program */
#define	MAXNMLEN	16	/* For site's name, can be nickname */
#define MAXADDRLEN	128	/* Ok for IP, decnet, OSI */
#define MAXTAGLEN	8	/* For classifying/troubleshooting ? */

/* data structure of NOCOL event message */

/* site identifier */
typedef struct 
{
    char	name[MAXNMLEN];		/* site name (can also be a pseudo) */ 
    char	addr[MAXADDRLEN];	/* Okay for IP, DECnet, OSI */
/*    char	tag[MAXTAGLEN];		/* For tagging sites. Optional */
} SITE;	

/* variable info */
typedef struct
{
    char	name[MAXNMLEN];		/* name or keyword of variable */
    u_long	value;			/* variable value */
    u_long	threshold;		/* variable threshold, if applicable */
    char	units[8];		/* units of variable (pkts, ms) */
} VAR;

/* event format */
typedef struct 
{
    char	sender[MAXPROGNM];	/* 8 bytes of sender name */
    SITE		site;		/* site identifier */
    VAR			var;		/* variable info */
    unsigned char	mon;		/* 1 to 12; can be reduced to 4 bits */
    unsigned char	day;		/* 1 to 31; can be reduced to 5 bits */
    unsigned char	hour;		/* 0 to 23; can be reduced to 5 bits */
    unsigned char	min;		/* 0 to 59; can be reduced to 6 bits */
    unsigned char	severity;	/* event severity; need only 2 bits */
    unsigned char	loglevel;	/* for logging; need only 2 bits */
    unsigned char	nocop;		/* operations flag indicating STATE */
} EVENT;

/* Event severities. */
#define E_CRITICAL	1
#define E_ERROR		2
#define E_WARNING	3
#define E_INFO		4

/* Text used to refer to severity levels. First is null since start with 1 */
static char *severity_txt[] = {
    "BAD-0", "Critical", "Error", "Warning", "Info", "BAD-5"} ;

/* 'nocop' flags indicating various 'STATE's that a site can be in */

#define n_UP		0x01
#define n_DOWN		0x02
#define n_UNKNOWN	0x04			/* not tested yet ? */
#define n_TEST		0x08			/* Site in test mode */
#define n_NODISPLAY	0x10			/* Ignore while displaying */

/*
 * Some flag operations on mask 'm'. Since UP, DOWN, UNKNOWN are mutually
 * exclusive, this macro sets the desired mask and clears the others
 * (No, the DOUN is not a typo, it stands for DOwn and UNknown
 */
#define SETF_UPDOUN(mask, f)	((mask & ~(n_UP | n_DOWN | n_UNKNOWN)) | (f))

struct nocop_txt_s
{
    int		v ;
    char	*str ;		/* Text used to refer to nocop flags */
};
static struct nocop_txt_s nocop_txt[] = {
  {n_UP, "up"},
  {n_DOWN, "down"},
  {n_UNKNOWN, "unknown"},
  {n_TEST, "test"},
  {n_NODISPLAY ,"nodisplay"},
  {0, ""}
} ;



#endif	/* __nocol_h  */
