/* $Header: /home/vikas/src/nocol/include/RCS/portmon.h,v 1.3 1998/07/31 18:18:58 vikas Exp $  */

#ifndef __portmon_h
# define __portmon_h

#include "nocol.h"

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>

#include <unistd.h>		/* for lseek */
#include <sys/file.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <signal.h>
#include <netdb.h>


/* # define CONFIGFILE       "../../etc/portmon-confg"	/* in ETCDIR */

#define VARUNITS	"Port"
#define MAXHOSTS  	128
#define POLLINTERVAL  	(60*15)		/* seconds between passes */
#define RTIMEOUT  60		/* seconds for socket read() timeout */
#define CONNECT_TIMEOUT  10	/* secs for initial response/read timeout */

struct _response
{
  char  *response;
  int   severity;
} ;

struct _harray
{
  char  *hname ;		/* Name for nocol struct */
  char  *ipaddr ;		/* IP name (or address) */
  char  *send ;			/* string to send remote site */
  int   port ;		       	/* port number being tested */
  int   maxseverity ;
  unsigned int   timeouts[3];	/* timeout in seconds for warn/err/crit */
  struct _response  responses[20] ;	/* max number of chat strings */
} hostarray[MAXHOSTS] ;

extern char *raw2newline();

#endif	/* ! __portmon_h */
