
/*
 * $Header: /home/vikas/netmgt/nocol/src/tpmon/RCS/poll_sites.c,v 1.7 1994/06/21 22:34:50 vikas Exp $
 */

/*+
 * FUNCTIONS:
 *	Test throughput to a site (NOCOL style). Makes one pass over the
 * entire data file.
 *
 * Adapted from poll_sites.c of 'pingmon' 1.15
 *
 * AUTHOR
 *	S. Spencer Sun, JvNCnet, June 1992
 */

/*
 * $Log: poll_sites.c,v $
 * Revision 1.7  1994/06/21  22:34:50  vikas
 * Changed lseek(L_SET)  to lseek(SEEK_SET)
 *
 * Revision 1.6  1994/05/23  04:00:24  vikas
 * Updated for release 4.0 of nocol
 *
 * Revision 1.5  1994/05/23  03:40:01  vikas
 * 'status' should have been 'int' and not long.
 *
 * Revision 1.4  1993/10/30  03:28:28  aggarwal
 * Deleted code for sending signal to watchdog. Now uses the
 * libnocol.a update_event() call.
 *
 * Revision 1.3  1992/06/15  17:05:13  aggarwal
 * Added '=' in the if(tp <= 0)
 *
 * Revision 1.2  1992/06/12  21:14:17  aggarwal
 * Changed the bps returned by tpmon to Kbps.
 *
 * Revision 1.1  1992/06/12  04:07:29  aggarwal
 * Initial revision
 *
 */


#include "nocol.h"			/*	common structures	*/
#include "tpmon.h"			/* program specific defines */

#include <signal.h>
#include <sys/file.h>
#include <arpa/nameser.h>

/*
 * Macro to escalate the severity of a site. Probably dont want the
 * severity to escalate to CRITICAL since the output is useful for info
 * purposes only and not testing reachability, etc.
 */
static int maxseverity = E_WARNING ; /* Max severity of events from tpmon */

/* #defines for finish_status */
#define REACHED_EOF 1
#define READ_ERROR 2

poll_sites(fdout)
     int fdout;				/* Descriptors to open files	*/
{
  extern int debug;			/* Enable debug (in pingmon.h)	*/
  static FILE *p_cmd;			/* for creating the ping cmd	*/
  EVENT v;			    	/* described in nocol.h		*/
  char line[MAXLINE];		 	/* to create the ping command	*/
  struct tm *ltime ;    
  time_t locclock ;			/* careful: don't use 'long'	*/
  int status;		       		/* site status			*/
  int bufsize;				/* for reading in file */
  long tp;

  if ( lseek(fdout, (off_t)0, SEEK_SET) == -1) { /* rewind the file	*/
    perror (prognm);
    return (-1);
  }

  /* 
   * until end of the file or erroneous data... one entire pass
   */

  while ( (bufsize = read (fdout, (char *)&v, sizeof(v))) == sizeof(v) )
  {
    /* all these default parameters are #defined in tpmon.h */
    tp = (long)throughput(v.site.addr, PORT_NUMBER, NUM_BYTES, BLOCKSIZE,
       PATTERN, RUN_TIME, debug);

    tp = tp /1000L ;			/* convert bits into Kbits */

    if (tp <= 0) /* some error occurred for this site */
    {
      v.nocop = SETF_UPDOUN(v.nocop, n_DOWN) ;	/* mark as down, dont log */
      continue;					/* keep old value, next site */
    }

    /* Here if we have a thruput value */

    if (tp < v.var.threshold)		/* if bad, then raise the severity */
      status = 0;
    else
      status = 1;
    update_event(&v, status, (u_long)tp, maxseverity) ;

    /* Now rewind to start of present record and write to the file	*/
     
    lseek(fdout,-(off_t)sizeof(v), SEEK_CUR);
    write (fdout, (char *)&v, sizeof(v));
     
  }	/* end of:    while (read..)	*/
    
  /*
   * Now determine why we broke out of the above loop
   */
    
  if (bufsize == 0)			/* reached end of the file	*/
    return (1);
  else {				/* error in output data file 	*/
    fprintf (stderr, "%s: Insufficient read data in output file", prognm);
    return (-1);
  }
}		/* end of:  poll_sites		*/

